﻿using System;
using System.ServiceModel;

namespace CustomWcfServiceClient
{
   class Program
   {
      static void Main(string[] args)
      {
         // HTTP Binding Objekt erstellen und Eigenschafen definieren
         BasicHttpBinding binding = new BasicHttpBinding();

         // Einfache HTTP-basierte Authentifizierung anwenden
         binding.Security.Mode = BasicHttpSecurityMode.TransportCredentialOnly;

         // NTLM als Authentifizierungsprotokoll verwenden
         binding.Security.Transport.ClientCredentialType =
             HttpClientCredentialType.Ntlm;

         // Zieladresse definieren
         EndpointAddress endpoint =
             new EndpointAddress("http://contoso.de/_vti_bin/CustomWcfService.svc");

         // WCF Service Proxy mit dem Binding und dem Endpunkt instaziieren
         CustomWcfService.Service1Client proxy =
            new CustomWcfService.Service1Client(binding, endpoint);

         // Aktuellen Benutzer impersonifizieren
         proxy.ClientCredentials.Windows.AllowedImpersonationLevel =
             System.Security.Principal.TokenImpersonationLevel.Impersonation;

         // Service-Methode aufrufen
         string[] response = proxy.GetLists();

         // Ergebnisse ausgeben
         foreach (string s in response)
         {
            Console.WriteLine(s);
         }
      }
   }
}